<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class Counter extends Model
{
    use LogsActivity;

    protected $fillable = [
        'first_name',
        'middle_name',            // отчество
        'last_name',
        'subgroup_manager_id',    // ссылка на менеджера подгруппы
    ];

    /**
     * Конфигурация логирования активности.
     */
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('Учетчики')           // удобное имя лога
            ->logOnlyDirty()                  // логировать только изменённые поля
            ->dontSubmitEmptyLogs()           // не создавать запись, если нет изменений
            ->logOnly(['first_name', 'middle_name', 'last_name', 'subgroup_manager_id']); // атрибуты для логирования
    }

    public function subgroupManagerPlans()
    {
        return $this->hasMany(PointPlan::class, 'counter_id');
    }
    /**
     * Связь с тем менеджером подгруппы, который его создал / к нему привязан.
     */
    public function subgroupManager()
    {
        return $this->belongsTo(User::class, 'subgroup_manager_id');
    }
    public function pointPlans()
    {
        return $this->hasMany(PointPlan::class, 'counter_id');
    }
}
