<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\User;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class District extends Model
{
    use LogsActivity;

    protected $table = 'districts';

    protected $fillable = [
        'name',
        'name_declined',
        'region_id',
        'group_manager_id',
        'subgroup_manager_id',
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('district')
            ->logOnlyDirty()               // only changed attributes
            ->dontSubmitEmptyLogs()        // skip logging if nothing changed
            ->logOnly([
                'name',
                'name_declined',
                'region_id',
                'group_manager_id',
                'subgroup_manager_id',
            ]);
    }

    public function region(): BelongsTo
    {
        return $this->belongsTo(Region::class , 'region_id');
    }
    public function points(): HasMany|District
    {
        return $this->hasMany(Point::class, 'district_id');
    }
    /** Менеджер группы */
    public function groupManager(): BelongsTo
    {
        return $this->belongsTo(User::class, 'group_manager_id');
    }

    /** Менеджер подгруппы */
    public function subgroupManager(): BelongsTo
    {
        return $this->belongsTo(User::class, 'subgroup_manager_id');
    }

    public function scopeOrdered($q)
    {
        $q->orderBy('name');
    }

}
