<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class MeasurementRecord extends Model
{
    use LogsActivity;

    protected $fillable = [
        'point_plan_id',
        'category_key',
        'hour',
        'count',
    ];
    protected $casts = [
        'weather'   => 'string',
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('Замеры интенсивности')
            ->logOnlyDirty()             // only attributes that actually changed
            ->dontSubmitEmptyLogs()      // skip if nothing changed
            ->logOnly([
                'point_plan_id',
                'category_key',
                'hour',
                'count',
            ]);
    }

}
