<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class Notification extends Model
{
    use HasFactory;
    use LogsActivity;

    protected $fillable = [
        'user_id',
        'title',
        'content',
        'is_read',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function scopeForUser($query, $userId)
    {
        return $query->where('user_id', $userId)
            ->orderBy('is_read') // сначала непрочитанные
            ->orderByDesc('created_at'); // потом новые
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('Уведомления')
            ->logOnlyDirty()                     // логировать только изменённые поля
            ->dontSubmitEmptyLogs()              // не создавать запись, если ничего не менялось
            ->logOnly([
                'user_id',
                'title',
                'content',
                'is_read',
            ]);
    }
}
