<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class PhotoReport extends Model
{
    use LogsActivity;

    protected $fillable = [
        'user_id',
        'request_id',
        'district_id',
        'status',
        'output_path',
        'error_message',
    ];

    /**
     * Настройки логирования Spatie Activitylog.
     */
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('Фотоотчет')      // имя лог-группы
            ->logOnlyDirty()                  // логировать только изменившиеся поля
            ->dontSubmitEmptyLogs()           // не записывать, если нет изменений
            ->logOnly([
                'request_id',
                'district_id',
                'user_id',
                'status',
                'output_path',
                'error_message',
                'public_url',
            ]);                               // какие поля логировать
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function request()
    {
        return $this->belongsTo(RequestSet::class, 'request_id');
    }
    public function district()
    {
        return $this->belongsTo(District::class);
    }
}
