<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class PlanFile extends Model
{
    use LogsActivity;

    protected $fillable = [
        'point_plan_id',
        'type',
        'path',
        'thumbnail',
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('Файлы')         // имя лога
            ->logOnlyDirty()                  // только изменённые поля
            ->dontSubmitEmptyLogs()           // без «пустых» записей
            ->logOnly([
                'point_plan_id',
                'type',
                'path',
            ]);
    }

    public function plan(): BelongsTo
    {
        return $this->belongsTo(PointPlan::class, 'point_plan_id');
    }

}
