<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class PointPlanPhoto extends Model
{
    use LogsActivity;

    protected $table = 'point_plan_photos';

    protected $fillable = [
        'point_plan_id',
        'file_path',
        'type',
        'comment',
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('point_plan_photo')      // имя лога
            ->logOnlyDirty()                      // только изменённые поля
            ->dontSubmitEmptyLogs()               // не создавать пустые записи
            ->logOnly([                     // какие атрибуты логировать
                'point_plan_id',
                'file_path',
                'type',
                'comment',
            ]);
    }

    public function plan()
    {
        return $this->belongsTo(PointPlan::class, 'point_plan_id');
    }
}
