<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\Pivot;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class PointRequest extends Pivot
{
    use LogsActivity;

    protected $table = 'point_request';

    protected $fillable = [
        'point_id',
        'request_id',
    ];

    /**
     * Настройки логирования активности для Spatie.
     */
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('Привязка точек к заявке')     // имя лога
            ->logOnlyDirty()                  // только изменённые поля
            ->dontSubmitEmptyLogs()           // не логировать, если нет изменений
            ->logOnly([
                'point_id',
                'request_id',
            ]);                               // атрибуты, которые сохраняем в логе
    }

    public function point()
    {
        return $this->belongsTo(Point::class, 'point_id');
    }

    public function request()
    {
        return $this->belongsTo(RequestSet::class, 'request_id');
    }
}
