<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\District;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;


class Region extends Model
{
    use LogsActivity;

    protected $table = 'regions';

    protected $fillable = [
        'name',
        'sen_manager_id'
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('region')                   // имя лога
            ->logOnlyDirty()                         // только изменённые поля
            ->dontSubmitEmptyLogs()                  // не создавать записи без изменений
            ->logOnly([                        // атрибуты для логирования
                'name',
                'sen_manager_id',
                'group_manager_id',
            ]);
    }

    public function districts(): HasMany|Region
    {
        return $this->hasMany(District::class, 'region_id');
    }
    public function senManager(): BelongsTo
    {
        return $this->belongsTo(User::class, 'sen_manager_id');
    }
    public function groupManager(): BelongsTo
    {
        return $this->belongsTo(User::class, 'group_manager_id');
    }
}
