<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class RequestPlanSignature extends Model
{
    use HasFactory;
    use LogsActivity;


    protected $fillable = [
        'request_id',
        'month',
        'year',
        'signed_by',
        'signed_at',
        'signature_public_key',
        'is_signed'
    ];

    protected $casts = [
        'signed_at' => 'datetime',
        'is_signed' => 'boolean',
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('Подписание заявки на месяц')
            ->logOnlyDirty()
            ->dontSubmitEmptyLogs()
            ->logOnly([
                'request_id',
                'month',
                'year',
                'signed_by',
                'signed_at',
                'is_signed',
            ]);
    }

    public function request(): BelongsTo
    {
        return $this->belongsTo(RequestSet::class, 'request_id');
    }

    public function signer(): BelongsTo
    {
        return $this->belongsTo(User::class, 'signed_by');
    }
}
