<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class RequestSet extends Model
{
    use HasFactory;
    use LogsActivity;

    protected $table = 'requests';

    protected $fillable = [
        'name', 'description', 'is_template'
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            // задаём понятное имя лога
            ->useLogName('Заявки')
            // будем логировать только изменённые поля
            ->logOnlyDirty()
            // не сохранять логи, если нет изменений
            ->dontSubmitEmptyLogs()
            // какие атрибуты сохранять в логе
            ->logOnly([
                'name',
                'description',
                'is_template',
            ]);
    }

    public function points()
    {
        return $this->belongsToMany(Point::class, 'point_request', 'request_id', 'point_id')
            ->using(PointRequest::class)
            ->withTimestamps();
    }

}
