<?php

namespace App\Models\Role;

use App\Models\RolePermission;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;


/**
 * Модель прав
 *
 * @package App\Models\Role\Permission
 * @property string $id
 * @property string $name
 * @property string $created_at
 * @property string $updated_at
 */

class Permission extends Model
{
    use HasFactory;
    use LogsActivity;

    protected $fillable = [
        'name',
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('Разрешения')           // вместо 'article'
            ->logOnlyDirty()                     // только изменённые поля
            ->dontSubmitEmptyLogs()              // не писать «пустые» логи
            ->logOnly(['name']);           // вместо ['title', 'published_at', 'status']
    }

    /**
     * Связь "многие ко многим" с моделью Role.
     */
    /**
     * Список ролей
     *
     * @return BelongsToMany
     */
    public function roles()
    {
        return $this->belongsToMany(Role::class, 'role_permission')->using(RolePermission::class);
    }


}
