<?php

namespace App\Models\Role;

use App\Models\RolePermission;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

/**
 * Модель ролей пользователя
 *
 * @package App\Models\Role\Role
 * @property string $id
 * @property string $name
 * @property string $created_at
 * @property string $updated_at
 */

class Role extends Model
{
    use HasFactory;
    use LogsActivity;

    protected $fillable = [
        'name',
    ];

    /**
     * Настройки логирования активности
     */
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('Роли')       // имя лога
            ->logOnlyDirty()           // только изменённые поля
            ->dontSubmitEmptyLogs()    // не создавать пустые записи
            ->logOnly(['name']);       // логировать только поле name
    }


    /**
     * Права роли
     *
     * @return BelongsToMany
     */
    public function permissions(): BelongsToMany
    {
        return $this->belongsToMany(Permission::class, 'role_permission')
            ->using(RolePermission::class);
    }

}
