<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Relations\Pivot;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class RolePermission extends Pivot
{
    use LogsActivity;

    protected $table = 'role_permission';
    public $incrementing = false;         // составной PK
    public $timestamps   = false;         // если не храните created_at

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('Назначение разрешения')
            ->logOnly(['role_id', 'permission_id'])
            ->logOnlyDirty()
            ->dontSubmitEmptyLogs();
    }
}
