<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class SchedulePlan extends Model
{
    use LogsActivity;

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('План-график')
            ->logOnlyDirty()
            ->dontSubmitEmptyLogs()
            ->logOnly([
                'year',
                'sen_manager_id',
                'signature',
                'signature_public_key',
                'hash',
            ]);
    }
    //
    protected $table = 'schedule_point_plans';

    protected $fillable = [
        'year',
        'sen_manager_id',
        'signature',
        'signature_public_key',
        'hash',
    ];

    public function senManager()
    {
        return $this->belongsTo(User::class, 'sen_manager_id');
    }
    public function pointPlans(){
        return $this->hasMany(PointPlan::class, 'schedule_id');
    }
    public function scopeCurrentYear($query)
    {
        return $query->where('year', Carbon::now()->year);
    }

    // has‑many‑through (Schedule → PointPlan → Point)
    public function points()
    {
        return $this->belongsToMany(
            Point::class,
            'point_plans',      // имя pivot-таблицы
            'schedule_id',      // FK на таблицу schedule_point_plans
            'point_id'          // FK на таблицу points
        )
            // Если в pivot-таблице есть ещё поля (day, timeStart и т.п.),
            // и они вам нужны в результатах, перечислите их:
            ->withPivot(['day', 'timeStart', /* … */])
            // Если хотите сразу с под-объектами
            ->with('plans');
    }

}
