<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class VehicleCategory extends Model
{
    use LogsActivity;

    protected $fillable = [
        'key',
        'label',
        'image_url'
    ];

    /**
     * @return LogOptions
     */
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('Категории ТС')         // имя лога
            ->logOnlyDirty()                     // только изменённые поля
            ->dontSubmitEmptyLogs()              // не писать «пустые» логи
            ->logOnly([                   // какие атрибуты логировать
                'key',
                'label',
                'image_url',
            ])
            ->setDescriptionForEvent(fn(string $eventName) => "Категория ТС была {$eventName}");
    }
}
