<?php
namespace App\Services;

class CalendarService
{
public static function build(int $year): array
{
$monthNames = [
1 => 'Январь', 2 => 'Февраль', 3 => 'Март', 4 => 'Апрель',
5 => 'Май', 6 => 'Июнь', 7 => 'Июль', 8 => 'Август',
9 => 'Сентябрь', 10 => 'Октябрь', 11 => 'Ноябрь', 12 => 'Декабрь',
];

$calendar = [];
for ($month = 1; $month <= 12; $month++) {
$daysInMonth = cal_days_in_month(CAL_GREGORIAN, $month, $year);
$calendar[] = [
'month' => $monthNames[$month],
'days' => range(1, $daysInMonth),
];
}

return $calendar;
}
}
