<?php
namespace App\Services;

use Carbon\Carbon;
use Carbon\CarbonPeriod;

class WorkdayCalendar
{
    /**
     * Вернёт список дат-строк Y-m-d, которые попадают в период
     * между $start и $end, за вычетом суббот, воскресений и праздников.
     *
     * @param string|Carbon $start
     * @param string|Carbon $end
     * @return array<string>
     */
    public function getWorkingDays($start, $end): array
    {
        $holidays = config('holidays', []);

        $period = CarbonPeriod::create($start, $end);

        $working = [];
        /** @var Carbon $day */
        foreach ($period as $day) {
            // isWeekday = Mon–Fri
            if (!$day->isWeekday()) {
                continue;
            }
            if (in_array($day->toDateString(), $holidays, true)) {
                continue;
            }
            $working[] = $day->toDateString();
        }

        return $working;
    }
}
