<?php

return [
    // Коэффициенты перехода по месяцам: 'peregon' и 'podhod'
    'K_month' => [
        'peregon' => [
            1 => 1.37,
            2 => 1.32,
            3 => 1.11,
            4 => 0.95,
            5 => 0.91,
            6 => 0.86,
            7 => 0.79,
            8 => 0.78,
            9 => 0.87,
            10 => 0.92,
            11 => 1.01,
            12 => 1.11,
        ],
        'podhod' => [
            1 => 1.37,
            2 => 1.39,
            3 => 1.17,
            4 => 0.95,
            5 => 0.83,
            6 => 0.78,
            7 => 0.75,
            8 => 0.77,
            9 => 0.83,
            10 => 0.89,
            11 => 1.01,
            12 => 1.16,
        ],
    ],

    // Коэффициенты перехода по дням недели: 'peregon' и 'podhod'
    'K_weekday' => [
        'podhod'  => [
            'mon' => 1.15,
            'tue' => 1.06,
            'wed' => 1.05,
            'thu' => 1.02,
            'fri' => 0.86,
            'sat' => 0.92,
            'sun' => 0.93,
        ],
        'peregon' => [
            'mon' => 1.15,
            'tue' => 1.00,
            'wed' => 1.00,
            'thu' => 0.92,
            'fri' => 0.83,
            'sat' => 1.02,
            'sun' => 1.11,
        ],
    ],

    // Коэффициенты перехода по часу (час начала => продолжительность => коэффициент) для 'peregon' и 'podhod'
    'K_hour' => [
        // Подходы к населенным пунктам (таблица К.3) :contentReference[oaicite:0]{index=0}:contentReference[oaicite:1]{index=1}
        'podhod' => [
            8  => [4 => 3.23, 5 => 3.31, 6 => 2.85, 7 => 2.33, 8 => 2.12, 9 => 1.86, 10 => 1.65, 11 => 1.50, 12 => 1.37],
            9  => [4 => 3.27, 5 => 3.32, 6 => 2.83, 7 => 2.32, 8 => 2.09, 9 => 1.82, 10 => 1.63, 11 => 1.39],
            10 => [4 => 3.30, 5 => 3.30, 6 => 2.82, 7 => 2.39, 8 => 2.03, 9 => 1.81, 10 => 1.63],
            11 => [4 => 3.25, 5 => 3.38, 6 => 2.78, 7 => 2.32, 8 => 2.03, 9 => 1.80],
            12 => [4 => 3.23, 5 => 3.33, 6 => 2.70, 7 => 2.31, 8 => 2.02],
            13 => [4 => 3.10, 5 => 3.18, 6 => 2.65, 7 => 2.29],
            14 => [4 => 3.90, 5 => 3.13, 6 => 2.65],
            15 => [4 => 3.88, 5 => 3.16],
            16 => [4 => 3.91],
            17 => [4 => 3.27],
        ],

        // Перегоны (таблица К.4) :contentReference[oaicite:2]{index=2}:contentReference[oaicite:3]{index=3}
        'peregon' => [
            8  => [4 => 3.33, 5 => 3.23, 6 => 2.69, 7 => 2.29, 8 => 1.97, 9 => 1.71, 10 => 1.51, 11 => 1.37, 12 => 1.27],
            9  => [4 => 3.98, 5 => 3.19, 6 => 2.63, 7 => 2.22, 8 => 1.90, 9 => 1.65, 10 => 1.38, 11 => 1.36],
            10 => [4 => 3.00, 5 => 3.18, 6 => 2.59, 7 => 2.17, 8 => 1.85, 9 => 1.63, 10 => 1.50],
            11 => [4 => 3.99, 5 => 3.10, 6 => 2.51, 7 => 2.09, 8 => 1.83, 9 => 1.66],
            12 => [4 => 3.86, 5 => 2.98, 6 => 2.31, 7 => 2.07, 8 => 1.85],
            13 => [4 => 3.63, 5 => 2.82, 6 => 2.36, 7 => 2.09],
            14 => [4 => 3.33, 5 => 2.77],
            15 => [4 => 3.38, 5 => 2.85],
            16 => [4 => 3.57],
            17 => [4 => 3.82],
        ],
    ],

    // Коэффициенты приведения к легковому автомобилю по категориям (ключи совпадают с ключами категорий)
    'K_to_car' => [
        'bike' => 0.5,
        'car'  => 1.0,
        'truck2'  => 1.5,
        'truck3'  => 1.8,
        'truck4'  => 2.0,
        'roadtrain4'  => 2.2,
        'roadtrain5'  => 2.7,
        'saddleroadtrain3'  => 2.2,
        'saddleroadtrain4'  => 2.7,
        'saddleroadtrain23'  => 2.7,
        'saddleroadtrain32'  => 2.7,
        'saddleroadtrain33'  => 3.2,
        'truck7'  => 3.2,
        'bus'  => 3.0,
    ],
];
