<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Validation\Rules\Email;
use Symfony\Component\String\UnicodeString;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('first_name')->comment('Имя');
            $table->string('middle_name')->comment('Отчество');
            $table->string('last_name')->comment('Фамилия');
            $table->string('position')->comment('Должность');
            $table->string('login')->unique()->comment('Логин');
            $table->date('birthday')->comment('Дата рождения');
            $table->unsignedBigInteger('role_id')->nullable();
            $table->foreign('role_id')->references('id')->on('roles')->onDelete('restrict');
            $table->boolean('is_active')->default(true)->comment('Активен ли пользователь');
            $table->string('password')->comment('Пароль');
            $table->string('token');
            $table->string('refresh_token');

            $table->text('public_key')->nullable()->comment('Публичный ключ');
            $table->text('private_key')->nullable()->comment('Приватный ключ');

            $table->unsignedBigInteger('region_id')->nullable();
            $table->unsignedBigInteger('district_id')->nullable();
            
            $table->rememberToken();
            $table->timestamps();
            
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('sessions');
    }
};
