<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('points', function (Blueprint $table) {
            $table->id();

            $table->decimal('latitude', 10, 7)->nullable()->comment('Широта'); // до 7 знаков после запятой
            $table->decimal('longitude', 10, 7)->nullable()->comment('Долгота');
            $table->string('name')->nullable()->comment('Наименование');
            $table->longText('geojson')->nullable()->comment('GeoJSON');
            $table->unsignedBigInteger('district_id')->nullable()->index();
            $table->foreign('district_id')->references('id')->on('districts')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('points', function (Blueprint $table) {
            $table->dropForeign(['district_id']);
        });
        Schema::dropIfExists('points');
    }
};
