<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schedule_point_plans', function (Blueprint $table) {
            $table->id();
            $table->year('year')->nullable();
            $table->unsignedBigInteger('sen_manager_id')->nullable();
            $table->foreign('sen_manager_id')->references('id')->on('users')->onDelete('cascade');
            // // Подпись
            $table->text('signature')->nullable();
            $table->text('signature_public_key')->nullable();
            $table->string('hash')->nullable();
            $table->timestamps();
        });
    }

    


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schedule_point_plans');
    }
};
