<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('point_plans', function (Blueprint $table) {
            $table->id();
            $table->date('day');
            $table->time('timeStart');
            $table->time('timeEnd');
            $table->unsignedBigInteger('point_id');
            $table->unsignedBigInteger('schedule_id');
            $table->unsignedBigInteger('operator_id')->nullable();
            $table->boolean('isWorkedOut')->default(false);
            $table->longText('comment')->nullable();
            $table->text('signature')->nullable();
            $table->text('signature_public_key')->nullable();
            $table->string('hash')->nullable();
            $table->timestamps();
        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('point_plans', function (Blueprint $table) {
            $table->dropForeign(['operator_id']);
            $table->dropForeign(['point_id']);
            $table->dropForeign(['schedule_id']);
        });
        Schema::dropIfExists('point_plans');
    }
};
