<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('point_plans', function (Blueprint $table) {
            $table->foreign('schedule_id')
                  ->references('id')
                  ->on('schedule_point_plans')
                  ->onDelete('cascade');
    
            $table->foreign('point_id')
                  ->references('id')
                  ->on('points')
                  ->onDelete('cascade');
        });
    }
    
    public function down(): void
    {
        Schema::table('point_plans', function (Blueprint $table) {
            $table->dropForeign(['schedule_id']);
            $table->dropForeign(['point_id']);
        });
    }
};
