<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('point_plan_photos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('point_plan_id');
            $table->string('file_path');
            $table->enum('type', ['before', 'after']);
            $table->string('comment')->nullable();
            $table->timestamps();

            $table->foreign('point_plan_id')->references('id')->on('point_plans')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('point_plan_photos');
    }
};
