<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('points', function (Blueprint $table) {
            $table->decimal('length', 6, 2)->nullable()->after('longitude')->comment('Протяж. обслужваемых дорог');;
            $table->string('accounting_point')->nullable()->after('length')->comment('Пункт учета');
            $table->text('road_category')->nullable()->after('accounting_point')->comment('Категория дороги');
            $table->string('road_subcategory')->nullable()->after('road_category')->comment('подъезд или перегон');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('points', function (Blueprint $table) {
            $table->dropColumn([
                'length',
                'accounting_point',
                'road_category',
                'road_subcategory',
            ]);
        });
    }
};
