<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('points', function (Blueprint $table) {
            $table->integer('record_number')->nullable()->after('road_subcategory')->comment('Номер записи');
            $table->string('accounting_type')->nullable()->after('record_number')->comment('Тип пункта учета');
            $table->tinyInteger('monitoring_freq')->nullable()->after('accounting_type')->comment('Частота мониторинга (1=ежемесячно, 2=ежеквартально)');
            $table->tinyInteger('accounting_flag')->nullable()->after('monitoring_freq')->comment('Признак пункта учета (1=Подъезд, 2=Перегон)');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('points', function (Blueprint $table) {
            $table->dropColumn([
                'record_number',
                'accounting_type',
                'monitoring_freq',
                'accounting_flag',
            ]);
        });
    }
};
