<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('regions', function (Blueprint $table) {
            $table->unsignedBigInteger('group_manager_id')->nullable()->after('sen_manager_id');
            $table->foreign('group_manager_id')
                ->references('id')
                ->on('users')
                ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('regions', function (Blueprint $table) {
            $table->dropForeign(['group_manager_id']);
            $table->dropColumn('group_manager_id');
        });
    }
};
