<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('request_plan_signatures', function (Blueprint $table) {
            // кто подписал
            $table->foreignId('signed_by')
                ->nullable()
                ->after('year')
                ->constrained('users')
                ->cascadeOnDelete();

            // когда подписал
            $table->timestamp('signed_at')
                ->nullable()
                ->after('signed_by');

            // гарантируем, что по каждой заявке+месяцу подпись хранится только одна запись
            $table->unique(['request_id', 'month', 'year'], 'rps_request_month_year_unique');
        });
    }

    public function down(): void
    {
        Schema::table('request_plan_signatures', function (Blueprint $table) {
            $table->dropUnique('rps_request_month_year_unique');
            $table->dropForeign(['signed_by']);
            $table->dropColumn(['signed_by', 'signed_at']);
        });
    }
};
