<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('point_plans', function (Blueprint $table) {
            $table->unsignedBigInteger('request_id')->nullable()->after('schedule_id');
            $table->foreign('request_id')
                ->references('id')->on('requests')
                ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::table('point_plans', function (Blueprint $table) {
            $table->dropForeign(['request_id']);
            $table->dropColumn('request_id');
        });
    }
};
