<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('measurement_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('point_plan_id')->constrained('point_plans')->cascadeOnDelete();
            $table->string('category_key');
            $table->string('hour',5);            // "08:00"
            $table->unsignedInteger('count')->default(0);
            $table->boolean('direction');        // 0 = встречное, 1 = попутное
            $table->timestamps();

            $table->unique(['point_plan_id','category_key','hour','direction'], 'uniq_measure');
        });
    }

    public function down()
    {
        Schema::dropIfExists('measurement_records');
    }
};
