<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('plan_files', function (Blueprint $table) {
            $table->id();
            $table->foreignId('point_plan_id')->constrained('point_plans')->cascadeOnDelete();
            $table->string('type');              // 'before', 'after', 'doc'
            $table->string('path');              // путь в storage
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('plan_files');
    }
};
