<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('vehicle_categories', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();      // например "car", "bus", "truck"
            $table->string('label');              // "Легковой", "Автобус", "Грузовой"
            $table->string('image_url');          // путь до иконки
            $table->timestamps();
        });

        // посеем базовые категории
        DB::table('vehicle_categories')->insert([
            ['key'=>'bike',   'label'=>'Мотоциклы', 'image_url'=>'/icons/car.png'],
            ['key'=>'car',   'label'=>'Легковые автомобили, небольшие грузовики (фургоны) и другие автомобили с прицепом и без него',  'image_url'=>'/icons/bus.png'],
            ['key'=>'truck2', 'label'=>'Двухосные грузовые автомобили', 'image_url'=>'/icons/truck.png'],
            ['key'=>'truck3',  'label'=>'Трехосные грузовые автомобили','image_url'=>'/icons/bike.png'],
            ['key'=>'truck4',  'label'=>'Четырехосные грузовые автомобили','image_url'=>'/icons/bike.png'],
            ['key'=>'roadtrain4',  'label'=>'Четырехосные автопоезда (двухосный грузовой автомобиль с прицепом)','image_url'=>'/icons/bike.png'],
            ['key'=>'roadtrain5',  'label'=>'Пятиосные автопоезда (трехосный грузовой автомобиль с прицепом)','image_url'=>'/icons/bike.png'],
            ['key'=>'saddleroadtrain3',  'label'=>'Трехосные седельные автопоезда (двухосный седельный тягач с полуприцепом)','image_url'=>'/icons/bike.png'],
            ['key'=>'saddleroadtrain4',  'label'=>'Четырехосные седельные автопоезда (двухосный седельный тягач с полуприцепом)','image_url'=>'/icons/bike.png'],
            ['key'=>'saddleroadtrain23',  'label'=>'Пятиосные седельные автопоезда (двухосный седельный тягач с полуприцепом)','image_url'=>'/icons/bike.png'],
            ['key'=>'saddleroadtrain32',  'label'=>'Пятиосные седельные автопоезда (трехосный седельный тягач с полуприцепом)','image_url'=>'/icons/bike.png'],
            ['key'=>'saddleroadtrain33',  'label'=>'Шестиосные седельные автопоезда','image_url'=>'/icons/bike.png'],
            ['key'=>'truck7',  'label'=>'Автомобили с семью и более осями и другие','image_url'=>'/icons/bike.png'],
            ['key'=>'bus',  'label'=>'Автобусы','image_url'=>'/icons/bike.png'],


        ]);
    }

    public function down()
    {
        Schema::dropIfExists('vehicle_categories');
    }
};
