<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('point_plans', function (Blueprint $table) {
            $table->boolean('direction')
                ->default(1)
                ->after('is_active')
                ->comment('1 – попутное, 0 – встречное');
        });
    }
    public function down(): void
    {
        Schema::table('point_plans', function (Blueprint $table) {
            $table->dropColumn('direction');
        });
    }
};
