<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('measurement_records', function (Blueprint $table) {
            // на всякий случай проверяем, что столбец есть
            if (Schema::hasColumn('measurement_records', 'direction')) {
                $table->dropColumn('direction');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('measurement_records', function (Blueprint $table) {
            // добавляем обратно с тем же типом и значением по умолчанию
            $table->boolean('direction')
                ->default(1)
                ->after('count');
        });
    }
};
