<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('counters', function (Blueprint $table) {
            // 1) колонка для отчества
            $table->string('middle_name')->nullable()->after('first_name');

            // 2) колонка для связи с менеджером подгруппы (считаем, что менеджеры хранятся в таблице users)
            $table->unsignedBigInteger('subgroup_manager_id')->nullable()->after('middle_name');

            // Внешний ключ: subgroup_manager_id → users.id
            $table->foreign('subgroup_manager_id')
                ->references('id')
                ->on('users')
                ->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('counters', function (Blueprint $table) {
            $table->dropForeign(['subgroup_manager_id']);
            $table->dropColumn('subgroup_manager_id');
            $table->dropColumn('middle_name');
        });
    }
};
