<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('photo_reports', function (Blueprint $table) {
            $table->id();
            // Ссылаемся на вашу таблицу 'requests'
            $table->foreignId('request_id')
                ->constrained('requests')
                ->cascadeOnDelete();
            // Район может быть NULL
            $table->foreignId('district_id')
                ->nullable()
                ->constrained('districts')
                ->nullOnDelete();
            // Кто запустил отчёт
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete();
            // Статус - ждёт, обрабатывается, готов, ошибка
            $table->enum('status', ['pending','processing','done','error'])
                ->default('pending');
            // Куда положили PDF
            $table->string('output_path')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('photo_reports');
    }
};
