--
-- PostgreSQL database dump
--

-- Dumped from database version 17.4 (Debian 17.4-1.pgdg120+2)
-- Dumped by pg_dump version 17.4 (Ubuntu 17.4-1.pgdg24.04+2)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: cache; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cache (
    key character varying(255) NOT NULL,
    value text NOT NULL,
    expiration integer NOT NULL
);


--
-- Name: cache_locks; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cache_locks (
    key character varying(255) NOT NULL,
    owner character varying(255) NOT NULL,
    expiration integer NOT NULL
);


--
-- Name: counters; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.counters (
    id bigint NOT NULL,
    first_name character varying(255) NOT NULL,
    last_name character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


--
-- Name: counters_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.counters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: counters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.counters_id_seq OWNED BY public.counters.id;


--
-- Name: districts; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.districts (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    region_id bigint,
    group_manager_id bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    name_declined character varying(255),
    subgroup_manager_id bigint
);


--
-- Name: districts_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.districts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: districts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.districts_id_seq OWNED BY public.districts.id;


--
-- Name: logs; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.logs (
    id bigint NOT NULL,
    model_id bigint,
    model_type character varying(255),
    change character varying(255),
    action character varying(255),
    old_value text,
    new_value text,
    created_by bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


--
-- Name: logs_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.logs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.logs_id_seq OWNED BY public.logs.id;


--
-- Name: measurement_records; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.measurement_records (
    id bigint NOT NULL,
    point_plan_id bigint NOT NULL,
    category_key character varying(255) NOT NULL,
    hour character varying(5) NOT NULL,
    count integer DEFAULT 0 NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


--
-- Name: measurement_records_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.measurement_records_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: measurement_records_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.measurement_records_id_seq OWNED BY public.measurement_records.id;


--
-- Name: migrations; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.migrations (
    id integer NOT NULL,
    migration character varying(255) NOT NULL,
    batch integer NOT NULL
);


--
-- Name: migrations_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.migrations_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: migrations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.migrations_id_seq OWNED BY public.migrations.id;


--
-- Name: notifications; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.notifications (
    id bigint NOT NULL,
    user_id bigint NOT NULL,
    title character varying(255) NOT NULL,
    content text NOT NULL,
    is_read boolean DEFAULT false NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


--
-- Name: notifications_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.notifications_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: notifications_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.notifications_id_seq OWNED BY public.notifications.id;


--
-- Name: permissions; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.permissions (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


--
-- Name: permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: permissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.permissions_id_seq OWNED BY public.permissions.id;


--
-- Name: personal_access_tokens; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.personal_access_tokens (
    id bigint NOT NULL,
    tokenable_type character varying(255) NOT NULL,
    tokenable_id bigint NOT NULL,
    name character varying(255) NOT NULL,
    token character varying(64) NOT NULL,
    abilities text,
    last_used_at timestamp(0) without time zone,
    expires_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


--
-- Name: personal_access_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.personal_access_tokens_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: personal_access_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.personal_access_tokens_id_seq OWNED BY public.personal_access_tokens.id;


--
-- Name: plan_files; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.plan_files (
    id bigint NOT NULL,
    point_plan_id bigint NOT NULL,
    type character varying(255) NOT NULL,
    path character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


--
-- Name: plan_files_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.plan_files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: plan_files_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.plan_files_id_seq OWNED BY public.plan_files.id;


--
-- Name: point_plan_photos; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.point_plan_photos (
    id bigint NOT NULL,
    point_plan_id bigint NOT NULL,
    file_path character varying(255) NOT NULL,
    type character varying(255) NOT NULL,
    comment character varying(255),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    CONSTRAINT point_plan_photos_type_check CHECK (((type)::text = ANY (ARRAY[('before'::character varying)::text, ('after'::character varying)::text])))
);


--
-- Name: point_plan_photos_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.point_plan_photos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: point_plan_photos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.point_plan_photos_id_seq OWNED BY public.point_plan_photos.id;


--
-- Name: point_plans; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.point_plans (
    id bigint NOT NULL,
    day date NOT NULL,
    "timeStart" time(0) without time zone NOT NULL,
    "timeEnd" time(0) without time zone NOT NULL,
    point_id bigint NOT NULL,
    schedule_id bigint NOT NULL,
    subgroup_manager_id bigint,
    "isWorkedOut" boolean DEFAULT false NOT NULL,
    comment text,
    signature text,
    signature_public_key text,
    hash character varying(255),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    is_active boolean DEFAULT true NOT NULL,
    counter_id bigint,
    request_id bigint,
    direction boolean DEFAULT true NOT NULL,
    weather character varying(255) DEFAULT 'Ясно'::character varying NOT NULL,
    CONSTRAINT point_plans_weather_check CHECK (((weather)::text = ANY (ARRAY[('Ясно'::character varying)::text, ('Пасмурно'::character varying)::text, ('Дождь'::character varying)::text, ('Снег'::character varying)::text])))
);


--
-- Name: COLUMN point_plans.is_active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.point_plans.is_active IS 'Активен ли план';


--
-- Name: COLUMN point_plans.direction; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.point_plans.direction IS '1 – попутное, 0 – встречное';


--
-- Name: point_plans_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.point_plans_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: point_plans_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.point_plans_id_seq OWNED BY public.point_plans.id;


--
-- Name: point_request; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.point_request (
    id bigint NOT NULL,
    point_id bigint NOT NULL,
    request_id bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


--
-- Name: point_request_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.point_request_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: point_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.point_request_id_seq OWNED BY public.point_request.id;


--
-- Name: points; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.points (
    id bigint NOT NULL,
    latitude numeric(10,7),
    longitude numeric(10,7),
    name character varying(255),
    geojson text,
    district_id bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    length numeric(6,2),
    accounting_point character varying(255),
    road_category text,
    road_subcategory character varying(255),
    record_number integer,
    accounting_type character varying(255),
    monitoring_freq smallint,
    accounting_flag smallint,
    request_label character varying(255),
    is_active boolean DEFAULT true NOT NULL
);


--
-- Name: COLUMN points.latitude; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.latitude IS 'Широта';


--
-- Name: COLUMN points.longitude; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.longitude IS 'Долгота';


--
-- Name: COLUMN points.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.name IS 'Наименование';


--
-- Name: COLUMN points.geojson; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.geojson IS 'GeoJSON';


--
-- Name: COLUMN points.length; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.length IS 'Протяж. обслужваемых дорог';


--
-- Name: COLUMN points.accounting_point; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.accounting_point IS 'Пункт учета';


--
-- Name: COLUMN points.road_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.road_category IS 'Категория дороги';


--
-- Name: COLUMN points.road_subcategory; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.road_subcategory IS 'подъезд или перегон';


--
-- Name: COLUMN points.record_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.record_number IS 'Номер записи';


--
-- Name: COLUMN points.accounting_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.accounting_type IS 'Тип пункта учета';


--
-- Name: COLUMN points.monitoring_freq; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.monitoring_freq IS 'Частота мониторинга (1=ежемесячно, 2=ежеквартально)';


--
-- Name: COLUMN points.accounting_flag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.accounting_flag IS 'Признак пункта учета (1=Подъезд, 2=Перегон)';


--
-- Name: COLUMN points.is_active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.points.is_active IS 'Активна ли точка';


--
-- Name: points_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.points_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: points_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.points_id_seq OWNED BY public.points.id;


--
-- Name: regions; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.regions (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    sen_manager_id bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    group_manager_id bigint
);


--
-- Name: COLUMN regions.sen_manager_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.regions.sen_manager_id IS 'Старший менеджер';


--
-- Name: regions_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.regions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: regions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.regions_id_seq OWNED BY public.regions.id;


--
-- Name: request_plan_signatures; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.request_plan_signatures (
    id bigint NOT NULL,
    request_id bigint NOT NULL,
    month integer NOT NULL,
    year integer NOT NULL,
    signature text,
    signature_public_key text,
    is_signed boolean DEFAULT false NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    signed_by bigint,
    signed_at timestamp(0) without time zone
);


--
-- Name: request_plan_signatures_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.request_plan_signatures_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: request_plan_signatures_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.request_plan_signatures_id_seq OWNED BY public.request_plan_signatures.id;


--
-- Name: requests; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.requests (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    description text,
    is_template boolean DEFAULT false NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


--
-- Name: requests_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.requests_id_seq OWNED BY public.requests.id;


--
-- Name: role_permission; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.role_permission (
    role_id bigint NOT NULL,
    permission_id bigint NOT NULL
);


--
-- Name: roles; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.roles (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


--
-- Name: roles_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.roles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: roles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.roles_id_seq OWNED BY public.roles.id;


--
-- Name: schedule_point_plans; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.schedule_point_plans (
    id bigint NOT NULL,
    year integer,
    sen_manager_id bigint,
    signature text,
    signature_public_key text,
    hash character varying(255),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


--
-- Name: schedule_point_plans_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.schedule_point_plans_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: schedule_point_plans_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.schedule_point_plans_id_seq OWNED BY public.schedule_point_plans.id;


--
-- Name: sessions; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sessions (
    id character varying(255) NOT NULL,
    user_id bigint,
    ip_address character varying(45),
    user_agent text,
    payload text NOT NULL,
    last_activity integer NOT NULL
);


--
-- Name: users; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.users (
    id bigint NOT NULL,
    first_name character varying(255) NOT NULL,
    middle_name character varying(255) NOT NULL,
    last_name character varying(255) NOT NULL,
    "position" character varying(255) NOT NULL,
    login character varying(255) NOT NULL,
    birthday date NOT NULL,
    role_id bigint,
    is_active boolean DEFAULT true NOT NULL,
    password character varying(255) NOT NULL,
    token character varying(255) NOT NULL,
    refresh_token character varying(255) NOT NULL,
    public_key text,
    private_key text,
    region_id bigint,
    district_id bigint,
    remember_token character varying(100),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


--
-- Name: COLUMN users.first_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.users.first_name IS 'Имя';


--
-- Name: COLUMN users.middle_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.users.middle_name IS 'Отчество';


--
-- Name: COLUMN users.last_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.users.last_name IS 'Фамилия';


--
-- Name: COLUMN users."position"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.users."position" IS 'Должность';


--
-- Name: COLUMN users.login; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.users.login IS 'Логин';


--
-- Name: COLUMN users.birthday; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.users.birthday IS 'Дата рождения';


--
-- Name: COLUMN users.is_active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.users.is_active IS 'Активен ли пользователь';


--
-- Name: COLUMN users.password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.users.password IS 'Пароль';


--
-- Name: COLUMN users.public_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.users.public_key IS 'Публичный ключ';


--
-- Name: COLUMN users.private_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.users.private_key IS 'Приватный ключ';


--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.users_id_seq OWNED BY public.users.id;


--
-- Name: vehicle_categories; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.vehicle_categories (
    id bigint NOT NULL,
    key character varying(255) NOT NULL,
    label character varying(255) NOT NULL,
    image_url character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    sort_order integer DEFAULT 0 NOT NULL
);


--
-- Name: vehicle_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.vehicle_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: vehicle_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.vehicle_categories_id_seq OWNED BY public.vehicle_categories.id;


--
-- Name: counters id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.counters ALTER COLUMN id SET DEFAULT nextval('public.counters_id_seq'::regclass);


--
-- Name: districts id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.districts ALTER COLUMN id SET DEFAULT nextval('public.districts_id_seq'::regclass);


--
-- Name: logs id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.logs ALTER COLUMN id SET DEFAULT nextval('public.logs_id_seq'::regclass);


--
-- Name: measurement_records id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.measurement_records ALTER COLUMN id SET DEFAULT nextval('public.measurement_records_id_seq'::regclass);


--
-- Name: migrations id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.migrations ALTER COLUMN id SET DEFAULT nextval('public.migrations_id_seq'::regclass);


--
-- Name: notifications id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.notifications ALTER COLUMN id SET DEFAULT nextval('public.notifications_id_seq'::regclass);


--
-- Name: permissions id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.permissions ALTER COLUMN id SET DEFAULT nextval('public.permissions_id_seq'::regclass);


--
-- Name: personal_access_tokens id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.personal_access_tokens ALTER COLUMN id SET DEFAULT nextval('public.personal_access_tokens_id_seq'::regclass);


--
-- Name: plan_files id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.plan_files ALTER COLUMN id SET DEFAULT nextval('public.plan_files_id_seq'::regclass);


--
-- Name: point_plan_photos id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_plan_photos ALTER COLUMN id SET DEFAULT nextval('public.point_plan_photos_id_seq'::regclass);


--
-- Name: point_plans id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_plans ALTER COLUMN id SET DEFAULT nextval('public.point_plans_id_seq'::regclass);


--
-- Name: point_request id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_request ALTER COLUMN id SET DEFAULT nextval('public.point_request_id_seq'::regclass);


--
-- Name: points id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.points ALTER COLUMN id SET DEFAULT nextval('public.points_id_seq'::regclass);


--
-- Name: regions id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.regions ALTER COLUMN id SET DEFAULT nextval('public.regions_id_seq'::regclass);


--
-- Name: request_plan_signatures id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.request_plan_signatures ALTER COLUMN id SET DEFAULT nextval('public.request_plan_signatures_id_seq'::regclass);


--
-- Name: requests id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.requests ALTER COLUMN id SET DEFAULT nextval('public.requests_id_seq'::regclass);


--
-- Name: roles id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.roles ALTER COLUMN id SET DEFAULT nextval('public.roles_id_seq'::regclass);


--
-- Name: schedule_point_plans id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.schedule_point_plans ALTER COLUMN id SET DEFAULT nextval('public.schedule_point_plans_id_seq'::regclass);


--
-- Name: users id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users ALTER COLUMN id SET DEFAULT nextval('public.users_id_seq'::regclass);


--
-- Name: vehicle_categories id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.vehicle_categories ALTER COLUMN id SET DEFAULT nextval('public.vehicle_categories_id_seq'::regclass);


--
-- Name: cache_locks cache_locks_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.cache_locks
    ADD CONSTRAINT cache_locks_pkey PRIMARY KEY (key);


--
-- Name: cache cache_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.cache
    ADD CONSTRAINT cache_pkey PRIMARY KEY (key);


--
-- Name: counters counters_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.counters
    ADD CONSTRAINT counters_pkey PRIMARY KEY (id);


--
-- Name: districts districts_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.districts
    ADD CONSTRAINT districts_pkey PRIMARY KEY (id);


--
-- Name: logs logs_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.logs
    ADD CONSTRAINT logs_pkey PRIMARY KEY (id);


--
-- Name: measurement_records measurement_records_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.measurement_records
    ADD CONSTRAINT measurement_records_pkey PRIMARY KEY (id);


--
-- Name: migrations migrations_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.migrations
    ADD CONSTRAINT migrations_pkey PRIMARY KEY (id);


--
-- Name: notifications notifications_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.notifications
    ADD CONSTRAINT notifications_pkey PRIMARY KEY (id);


--
-- Name: permissions permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.permissions
    ADD CONSTRAINT permissions_pkey PRIMARY KEY (id);


--
-- Name: personal_access_tokens personal_access_tokens_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.personal_access_tokens
    ADD CONSTRAINT personal_access_tokens_pkey PRIMARY KEY (id);


--
-- Name: personal_access_tokens personal_access_tokens_token_unique; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.personal_access_tokens
    ADD CONSTRAINT personal_access_tokens_token_unique UNIQUE (token);


--
-- Name: plan_files plan_files_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.plan_files
    ADD CONSTRAINT plan_files_pkey PRIMARY KEY (id);


--
-- Name: point_plan_photos point_plan_photos_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_plan_photos
    ADD CONSTRAINT point_plan_photos_pkey PRIMARY KEY (id);


--
-- Name: point_plans point_plans_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_plans
    ADD CONSTRAINT point_plans_pkey PRIMARY KEY (id);


--
-- Name: point_request point_request_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_request
    ADD CONSTRAINT point_request_pkey PRIMARY KEY (id);


--
-- Name: points points_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.points
    ADD CONSTRAINT points_pkey PRIMARY KEY (id);


--
-- Name: regions regions_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.regions
    ADD CONSTRAINT regions_pkey PRIMARY KEY (id);


--
-- Name: request_plan_signatures request_plan_signatures_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.request_plan_signatures
    ADD CONSTRAINT request_plan_signatures_pkey PRIMARY KEY (id);


--
-- Name: requests requests_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.requests
    ADD CONSTRAINT requests_pkey PRIMARY KEY (id);


--
-- Name: role_permission role_permission_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.role_permission
    ADD CONSTRAINT role_permission_pkey PRIMARY KEY (role_id, permission_id);


--
-- Name: roles roles_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.roles
    ADD CONSTRAINT roles_pkey PRIMARY KEY (id);


--
-- Name: request_plan_signatures rps_request_month_year_unique; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.request_plan_signatures
    ADD CONSTRAINT rps_request_month_year_unique UNIQUE (request_id, month, year);


--
-- Name: schedule_point_plans schedule_point_plans_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.schedule_point_plans
    ADD CONSTRAINT schedule_point_plans_pkey PRIMARY KEY (id);


--
-- Name: sessions sessions_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sessions
    ADD CONSTRAINT sessions_pkey PRIMARY KEY (id);


--
-- Name: schedule_point_plans unique_year_manager; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.schedule_point_plans
    ADD CONSTRAINT unique_year_manager UNIQUE (year, sen_manager_id);


--
-- Name: users users_login_unique; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_login_unique UNIQUE (login);


--
-- Name: users users_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: vehicle_categories vehicle_categories_key_unique; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.vehicle_categories
    ADD CONSTRAINT vehicle_categories_key_unique UNIQUE (key);


--
-- Name: vehicle_categories vehicle_categories_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.vehicle_categories
    ADD CONSTRAINT vehicle_categories_pkey PRIMARY KEY (id);


--
-- Name: personal_access_tokens_tokenable_type_tokenable_id_index; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX personal_access_tokens_tokenable_type_tokenable_id_index ON public.personal_access_tokens USING btree (tokenable_type, tokenable_id);


--
-- Name: points_district_id_index; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX points_district_id_index ON public.points USING btree (district_id);


--
-- Name: sessions_last_activity_index; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX sessions_last_activity_index ON public.sessions USING btree (last_activity);


--
-- Name: sessions_user_id_index; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX sessions_user_id_index ON public.sessions USING btree (user_id);


--
-- Name: districts districts_manager_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.districts
    ADD CONSTRAINT districts_manager_id_foreign FOREIGN KEY (group_manager_id) REFERENCES public.users(id) ON DELETE CASCADE;


--
-- Name: districts districts_region_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.districts
    ADD CONSTRAINT districts_region_id_foreign FOREIGN KEY (region_id) REFERENCES public.regions(id) ON DELETE CASCADE;


--
-- Name: districts districts_subgroup_manager_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.districts
    ADD CONSTRAINT districts_subgroup_manager_id_foreign FOREIGN KEY (subgroup_manager_id) REFERENCES public.users(id) ON DELETE SET NULL;


--
-- Name: measurement_records measurement_records_point_plan_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.measurement_records
    ADD CONSTRAINT measurement_records_point_plan_id_foreign FOREIGN KEY (point_plan_id) REFERENCES public.point_plans(id) ON DELETE CASCADE;


--
-- Name: notifications notifications_user_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.notifications
    ADD CONSTRAINT notifications_user_id_foreign FOREIGN KEY (user_id) REFERENCES public.users(id) ON DELETE CASCADE;


--
-- Name: plan_files plan_files_point_plan_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.plan_files
    ADD CONSTRAINT plan_files_point_plan_id_foreign FOREIGN KEY (point_plan_id) REFERENCES public.point_plans(id) ON DELETE CASCADE;


--
-- Name: point_plan_photos point_plan_photos_point_plan_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_plan_photos
    ADD CONSTRAINT point_plan_photos_point_plan_id_foreign FOREIGN KEY (point_plan_id) REFERENCES public.point_plans(id) ON DELETE CASCADE;


--
-- Name: point_plans point_plans_counter_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_plans
    ADD CONSTRAINT point_plans_counter_id_foreign FOREIGN KEY (counter_id) REFERENCES public.counters(id);


--
-- Name: point_plans point_plans_point_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_plans
    ADD CONSTRAINT point_plans_point_id_foreign FOREIGN KEY (point_id) REFERENCES public.points(id) ON DELETE CASCADE;


--
-- Name: point_plans point_plans_request_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_plans
    ADD CONSTRAINT point_plans_request_id_foreign FOREIGN KEY (request_id) REFERENCES public.requests(id) ON DELETE CASCADE;


--
-- Name: point_plans point_plans_schedule_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_plans
    ADD CONSTRAINT point_plans_schedule_id_foreign FOREIGN KEY (schedule_id) REFERENCES public.schedule_point_plans(id) ON DELETE CASCADE;


--
-- Name: point_request point_request_point_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_request
    ADD CONSTRAINT point_request_point_id_foreign FOREIGN KEY (point_id) REFERENCES public.points(id) ON DELETE CASCADE;


--
-- Name: point_request point_request_request_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.point_request
    ADD CONSTRAINT point_request_request_id_foreign FOREIGN KEY (request_id) REFERENCES public.requests(id) ON DELETE CASCADE;


--
-- Name: points points_district_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.points
    ADD CONSTRAINT points_district_id_foreign FOREIGN KEY (district_id) REFERENCES public.districts(id) ON DELETE SET NULL;


--
-- Name: regions regions_group_manager_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.regions
    ADD CONSTRAINT regions_group_manager_id_foreign FOREIGN KEY (group_manager_id) REFERENCES public.users(id) ON DELETE SET NULL;


--
-- Name: regions regions_sen_manager_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.regions
    ADD CONSTRAINT regions_sen_manager_id_foreign FOREIGN KEY (sen_manager_id) REFERENCES public.users(id) ON DELETE CASCADE;


--
-- Name: request_plan_signatures request_plan_signatures_request_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.request_plan_signatures
    ADD CONSTRAINT request_plan_signatures_request_id_foreign FOREIGN KEY (request_id) REFERENCES public.requests(id) ON DELETE CASCADE;


--
-- Name: request_plan_signatures request_plan_signatures_signed_by_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.request_plan_signatures
    ADD CONSTRAINT request_plan_signatures_signed_by_foreign FOREIGN KEY (signed_by) REFERENCES public.users(id) ON DELETE CASCADE;


--
-- Name: role_permission role_permission_permission_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.role_permission
    ADD CONSTRAINT role_permission_permission_id_foreign FOREIGN KEY (permission_id) REFERENCES public.permissions(id) ON DELETE CASCADE;


--
-- Name: role_permission role_permission_role_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.role_permission
    ADD CONSTRAINT role_permission_role_id_foreign FOREIGN KEY (role_id) REFERENCES public.roles(id) ON DELETE CASCADE;


--
-- Name: schedule_point_plans schedule_point_plans_sen_manager_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.schedule_point_plans
    ADD CONSTRAINT schedule_point_plans_sen_manager_id_foreign FOREIGN KEY (sen_manager_id) REFERENCES public.users(id) ON DELETE CASCADE;


--
-- Name: users users_district_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_district_id_foreign FOREIGN KEY (district_id) REFERENCES public.districts(id) ON DELETE SET NULL;


--
-- Name: users users_region_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_region_id_foreign FOREIGN KEY (region_id) REFERENCES public.regions(id) ON DELETE SET NULL;


--
-- Name: users users_role_id_foreign; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_role_id_foreign FOREIGN KEY (role_id) REFERENCES public.roles(id) ON DELETE RESTRICT;


--
-- PostgreSQL database dump complete
--

--
-- PostgreSQL database dump
--

-- Dumped from database version 17.4 (Debian 17.4-1.pgdg120+2)
-- Dumped by pg_dump version 17.4 (Ubuntu 17.4-1.pgdg24.04+2)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Data for Name: migrations; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.migrations (id, migration, batch) FROM stdin;
1	0001_01_01_000001_create_cache_table	1
2	2025_01_01_000001_create_role_and_permissions_table	1
3	2025_03_25_180227_create_personal_access_tokens_table	1
4	2025_04_01_000000_create_users_table	1
5	2025_04_02_173833_create_regions_table	1
6	2025_04_03_174104_create_districts_table	1
7	2025_04_04_161528_create_logs_table	1
8	2025_04_08_115248_create_notifications_table	1
9	2025_04_08_184818_add_region_id_foreign_to_users_table	1
10	2025_04_09_074625_create_points_table	1
11	2025_04_09_112430_create_schedule_point_plans_table	1
12	2025_04_09_112432_create_point_plans_table	1
13	2025_04_09_115815_add_foreign_keys_to_point_plans_table	1
14	2025_04_11_144551_create_point_plan_photos_table	1
15	2025_04_16_135613_add_road_fields_to_points_table	2
16	2025_04_17_060049_add_monitoring_fields_to_points_table	3
17	2025_04_17_232936_add_is_active_to_point_plans_table	4
18	2025_04_21_051813_add_unique_schedule_year_per_manager	5
19	2025_04_22_212149_add_request_label_to_points_table	6
20	2025_04_23_041049_add_is_active_to_points_table	7
21	2025_04_25_142250_add_name_declined_to_districts_table	8
22	2025_04_30_070415_create_request_sets_table	9
23	2025_04_30_070507_create_point_request_table	9
24	2025_04_30_113900_adjust_roles_and_add_counter	10
25	2025_04_30_114048_create_counters_table	10
26	2025_04_30_114321_add_counter_id_to_point_plans	10
27	2025_04_30_114906_rename_operator_id_to_subgroup_manager_id_in_point_plans	10
28	2025_04_30_153312_add_group_manager_id_to_regions	11
29	2025_04_30_153444_add_subgroup_manager_id_to_districts	11
30	2025_05_02_103013_rename_manager_id_to_group_manager_id_in_districts_table	12
31	2025_05_03_130134_create_request_plan_signatures_table	13
32	2025_05_05_042829_add_signed_fields_to_request_plan_signatures_table	14
33	2025_05_05_090607_add_request_id_to_point_plans_table	14
34	2025_05_06_053306_create_measurement_records_table	15
35	2025_05_06_053501_create_plan_files_table	15
36	2025_05_06_061540_create_vehicle_categories_table	15
37	2025_05_06_075757_add_direction_to_point_plans_table	15
38	2025_05_06_083611_remove_direction_from_measurement_records	15
39	2025_05_07_074718_add_sort_order_to_vehicle_categories_table	16
40	2025_05_07_114155_add_weather_to_point_plans_table	17
\.


--
-- Name: migrations_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('public.migrations_id_seq', 40, true);


--
-- PostgreSQL database dump complete
--

