<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Str;
class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        User::create([
            'first_name' => 'Админ',
            'last_name' => 'Админов',
            'middle_name' => 'Админович',
            'login' => 'admin01',
            'birthday' => '2000-01-01',
            'position' => 'Администратор',
            'password' => bcrypt('password'), // Устанавливаем пароль для администратора
            'token' => Str::random(60),
            'refresh_token' => Str::random(60),
            'role_id' => 2, // ID роли администратора
            'is_active' => true
        ]);
        User::create([
            'first_name' => 'Иван',
            'last_name' => 'Иванович',
            'middle_name' => 'Иванов',
            'login' => 'ivan01',
            'birthday' => '2000-01-01',
            'position' => 'Оператор',
            'password' => bcrypt('password'), // Устанавливаем пароль для оператора
            'token' => Str::random(60),
            'refresh_token' => Str::random(60),
            'role_id' => 5, // ID роли оператора
            'is_active' => true
        ]);
        User::create([
            'first_name' => 'Петр',
            'last_name' => 'Петрович',
            'middle_name' => 'Петров',
            'login' => 'petr01',
            'birthday' => '2000-01-01',
            'position' => 'Районный менеджер',
            'password' => bcrypt('password'), // Устанавливаем пароль для районного менеджера
            'token' => Str::random(60),
            'refresh_token' => Str::random(60),
            'role_id' => 4, // ID роли районного менеджера
            'is_active' => true
        ]);
        User::create([
            'first_name' => 'Андрей',
            'last_name' => 'Андреевич',
            'middle_name' => 'Андреев',
            'login' => 'andrey01',
            'birthday' => '2000-01-01',
            'position' => 'Региональный менеджер',
            'password' => bcrypt('password'), // Устанавливаем пароль для региональный менеджер
            'token' => Str::random(60),
            'refresh_token' => Str::random(60),
            'role_id' => 3, // ID роли региональный менеджер
            'is_active' => true
        ]);

        User::create([
            'first_name' => 'Сергей',
            'last_name' => 'Сергеевич',
            'middle_name' => 'Сергеев',
            'login' => 'sergey01',
            'birthday' => '1990-05-15',
            'position' => 'Региональный менеджер',
            'password' => bcrypt('password'),
            'token' => Str::random(60),
            'refresh_token' => Str::random(60),
            'role_id' => 3,
            'is_active' => true,
        ]);
        
        // Пользователь 2
        User::create([
            'first_name' => 'Мария',
            'last_name' => 'Петровна',
            'middle_name' => 'Петрова',
            'login' => 'maria01',
            'birthday' => '1985-03-22',
            'position' => 'Региональный менеджер',
            'password' => bcrypt('password'),
            'token' => Str::random(60),
            'refresh_token' => Str::random(60),
            'role_id' => 3,
            'is_active' => true,
        ]);
        
        // Пользователь 3
        User::create([
            'first_name' => 'Иван',
            'last_name' => 'Иванович',
            'middle_name' => 'Иванов',
            'login' => 'ivan02',
            'birthday' => '1995-07-10',
            'position' => 'Региональный менеджер',
            'password' => bcrypt('password'),
            'token' => Str::random(60),
            'refresh_token' => Str::random(60),
            'role_id' => 3,
            'is_active' => true,
        ]);
    }
}
