<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Str;

class DeveloperSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        User::create([
            'first_name' => 'Алекей',
            'last_name' => 'Дьяченко',
            'middle_name' => 'Петрович',
            'login' => 'aleksey01',
            'position' => 'Разработчик',
            'birthday' => '1989-03-16',
            'password' => bcrypt('password'), // Устанавливаем пароль для администратора
            'token' => Str::random(60),
            'refresh_token' => Str::random(60),
            'role_id' => 1, // ID роли оазработчика
            'is_active' => true
        ]);
        User::create([
            'first_name' => 'Денис',
            'last_name' => 'Ефремов',
            'middle_name' => 'Васильевич',
            'birthday' => '1989-03-16',
            'login' => 'denis01',
            'position' => 'Разработчик',
            'password' => bcrypt('password'),
            'token' => Str::random(60),
            'refresh_token' => Str::random(60),
            'role_id' => 1,
            'is_active' => true
        ]);
        User::create([
            'first_name' => 'Александр',
            'last_name' => 'Коломиец',
            'middle_name' => 'Сергеевич',
            'login' => 'aleksandr01',
            'position' => 'Разработчик',
            'birthday' => '1989-03-16',
            'password' => bcrypt('password'), // Устанавливаем пароль для оазработчика
            'token' => Str::random(60),
            'refresh_token' => Str::random(60),
            'role_id' => 1, // ID роли оазработчика
            'is_active' => true
        ]);
    }
}
