<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Models\Role\Permission;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Config;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $PERMISSION_LIST = Config::get('permission-list');
        foreach ($PERMISSION_LIST as $permission) {
            Permission::create([
                'name' => $permission,
            ]);
        }
    }
}
