<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Region;
use App\Models\District;

class RegionWithDistrictsSeeder extends Seeder
{
    public function run(): void
    {
        // Создаём регион
        $region = Region::firstOrCreate([
            'name' => 'Оренбургская область',
        ]);

        // Список районов
        $districts = [
            'Абдулинский район',
            'Адамовский район',
            'Акбулакский район',
            'Александровский район',
            'Асекеевский район',
            'Бугурусланский район',
            'Бузулукский район',
            'Беляевский район',
            'Гайский район',
            'Грачёвский район',
            'Домбаровский район',
            'Илекский район',
            'Кваркенский район',
            'Кувандыкский район',
            'Красногвардейский район',
            'Курманаевский район',
            'Матвеевский район',
            'Новоорский район',
            'Новосергиевский район',
            'Оренбургский район',
            'Октябрьский район',
            'Орский район',
            'Переволоцкий район',
            'Пономарёвский район',
            'Первомайский район',
            'Саракташский район',
            'Светлинский район',
            'Северный район',
            'Соль-Илецкий район',
            'Сакмарский район',
            'Сорочинский район',
            'Ташлинский район',
            'Тоцкий район',
            'Тюльганский район',
            'Шарлыкский район',
            'Ясненский район',
            'Оренбургский ДРСУ',
        ];
        // Добавляем районы
        foreach ($districts as $name) {
            District::firstOrCreate([
                'name' => $name,
                'region_id' => $region->id,
            ]);
        }
    }
}
