<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Role\Role;
use App\Models\Role\Permission;
use Illuminate\Support\Facades\Config;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {   
        $ROLE_PERMISSION = Config::get('role-permission');

        foreach ($ROLE_PERMISSION as $roleName => $permissionSlugs) {
            $role = Role::where('name', $roleName)->first();
    
            foreach ($permissionSlugs as $slug) {
                $permission = Permission::where('name', $slug)->first();
                
                if ($role && $permission) {
                    $role->permissions()->syncWithoutDetaching([$permission->id]);
                }
            }
        }
        
    }
}
