<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>{{ $title }} — {{ $subtitle }}</title>
    <style>
        @page {
            size: A4;
            margin: 0
        }

        body {
            margin: 0;
            padding: 10mm;
            font-family: DejaVu Sans;
            font-size: 10pt
        }

        .page {
            width: 190mm;
            height: 260mm; /* 297 − 2×10 */
            page-break-after: always;
        }

        .page:last-child {
            page-break-after: avoid !important;
        }

        .header {
            font-size: 12pt;
            margin-bottom: 5mm;
        }

        /* таблица фиксированного layout, занимает всю высоту контента */
        table {
            border-collapse: collapse;
            width: 100%;
            table-layout: fixed;

        }

        /* каждая из 5 строк по 1/5 высоты */
        tr {
            height: 37mm; /* 277 мм / 5 */
        }

        td {
            border: 1px solid #666666;
            padding: 0;
        }

        td img {
            display: block;
            width: 100%;
            height: 37mm;
            object-fit: cover;
            z-index: 0;
            /* вот оно: подхватить ориентацию из EXIF, если есть */
            image-orientation: from-image;
        }

        .caption {
            bottom: 0;
            left: 0;
            width: 100%;
            background-color: #FFFFFF; /* только фон полупрозрачный */
            color: #000000;
            font-size: 6pt;
            padding: 1mm;
        }

        .caption > .text {
            position: relative; /* отключаем наследование opacity от родителя */
            opacity: 1;
        }

        .footer {
            bottom: 10mm;
            left: 10mm;
            right: 10mm;
            font-size: 10pt;
        }

        .signature-img {
            width: 40mm;
            margin-left: 60mm;
            margin-top: -15mm;
        }

        .stamp-img {
            width: 35mm;
            margin-left: 80mm;
            margin-top: -35mm;
        }
    </style>
</head>
<body>
@php
    $perPage = 15;
    $pages   = array_chunk($photos, $perPage);
@endphp

@foreach($pages as $pageIndex => $photosPage)
    {{-- докидываем пустыми до ровно 15 --}}
    @php $photosPage = array_pad($photosPage, $perPage, null); @endphp

    <div class="page">

        @if($loop->first)
            <div class="header"><strong>{{ $title }} {{ $subtitle }}</strong></div>
        @endif

        <table>
            @for($r = 0; $r < 5; $r++)
                <tr>
                    @for($c = 0; $c < 3; $c++)
                        @php
                            $idx  = $r * 3 + $c;
                            $item = $photosPage[$idx];
                        @endphp
                        <td>
                            @if($item && !empty($item['data_uri']))
                                <img src="{{ $item['data_uri'] }}" alt="">
                                <div class="caption">
                                    <div class="text">
                                        {{ $item['point']['record_number'] }} {{ $item['point']['name'] }} ·
                                        {{ $item['day'] }} {{ $item['timeStart'] }} ·
                                        {{ $item['point']['latitude'] }}, {{ $item['point']['longitude'] }}
                                    </div>
                                </div>
                            @endif
                        </td>
                    @endfor
                </tr>
            @endfor
        </table>

        @if($pageIndex === count($pages) - 1)
            <div class="footer">
                @if(is_null($manager))
                    {{-- Без района: показываем директора + подпись и печать --}}
                    <div>
                        Генеральный директор ООО "ИТБ" ________________________ Иванов Д. А.
                    </div>
                    <div><img src="{{ $signatureData }}" class="signature-img" alt="Подпись"></div>
                    <div><img src="{{ $stampData }}" class="stamp-img" alt="Печать"></div>
                @else
                    {{-- Для конкретного района: показываем менеджера подгруппы --}}
                    <div>
                        Районный менеджер ООО "ИТБ" ________________________
                        {{ $manager->last_name }} {{ $manager->first_name }} {{ $manager->middle_name }}
                    </div>
                @endif
            </div>
        @endif
    </div>
@endforeach
</body>
</html>
