<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title><?php echo e($title); ?> — <?php echo e($subtitle); ?></title>
    <style>
        @page {
            size: A4;
            margin: 0
        }

        body {
            margin: 0;
            padding: 10mm;
            font-family: DejaVu Sans;
            font-size: 10pt
        }

        .page {
            width: 190mm;
            height: 260mm; /* 297 − 2×10 */
            page-break-after: always;
        }

        .page:last-child {
            page-break-after: avoid !important;
        }

        .header {
            font-size: 12pt;
            margin-bottom: 5mm;
        }

        /* таблица фиксированного layout, занимает всю высоту контента */
        table {
            border-collapse: collapse;
            width: 100%;
            table-layout: fixed;

        }

        /* каждая из 5 строк по 1/5 высоты */
        tr {
            height: 37mm; /* 277 мм / 5 */
        }

        td {
            border: 1px solid #666666;
            padding: 0;
        }

        td img {
            display: block;
            width: 100%;
            height: 37mm;
            object-fit: cover;
            z-index: 0;
            /* вот оно: подхватить ориентацию из EXIF, если есть */
            image-orientation: from-image;
        }

        .caption {
            bottom: 0;
            left: 0;
            width: 100%;
            background-color: #FFFFFF; /* только фон полупрозрачный */
            color: #000000;
            font-size: 6pt;
            padding: 1mm;
        }

        .caption > .text {
            position: relative; /* отключаем наследование opacity от родителя */
            opacity: 1;
        }

        .footer {
            bottom: 10mm;
            left: 10mm;
            right: 10mm;
            font-size: 10pt;
        }

        .signature-img {
            width: 40mm;
            margin-left: 60mm;
            margin-top: -15mm;
        }

        .stamp-img {
            width: 35mm;
            margin-left: 80mm;
            margin-top: -35mm;
        }
    </style>
</head>
<body>
<?php
    $perPage = 15;
    $pages   = array_chunk($photos, $perPage);
?>

<?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pageIndex => $photosPage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    
    <?php $photosPage = array_pad($photosPage, $perPage, null); ?>

    <div class="page">

        <?php if($loop->first): ?>
            <div class="header"><strong><?php echo e($title); ?> <?php echo e($subtitle); ?></strong></div>
        <?php endif; ?>

        <table>
            <?php for($r = 0; $r < 5; $r++): ?>
                <tr>
                    <?php for($c = 0; $c < 3; $c++): ?>
                        <?php
                            $idx  = $r * 3 + $c;
                            $item = $photosPage[$idx];
                        ?>
                        <td>
                            <?php if($item && !empty($item['data_uri'])): ?>
                                <img src="<?php echo e($item['data_uri']); ?>" alt="">
                                <div class="caption">
                                    <div class="text">
                                        <?php echo e($item['point']['record_number']); ?> <?php echo e($item['point']['name']); ?> ·
                                        <?php echo e($item['day']); ?> <?php echo e($item['timeStart']); ?> ·
                                        <?php echo e($item['point']['latitude']); ?>, <?php echo e($item['point']['longitude']); ?>

                                    </div>
                                </div>
                            <?php endif; ?>
                        </td>
                    <?php endfor; ?>
                </tr>
            <?php endfor; ?>
        </table>

        <?php if($pageIndex === count($pages) - 1): ?>
            <div class="footer">
                <?php if(is_null($manager)): ?>
                    
                    <div>
                        Генеральный директор ООО "ИТБ" ________________________ Иванов Д. А.
                    </div>
                    <div><img src="<?php echo e($signatureData); ?>" class="signature-img" alt="Подпись"></div>
                    <div><img src="<?php echo e($stampData); ?>" class="stamp-img" alt="Печать"></div>
                <?php else: ?>
                    
                    <div>
                        Районный менеджер ООО "ИТБ" ________________________
                        <?php echo e($manager->last_name); ?> <?php echo e($manager->first_name); ?> <?php echo e($manager->middle_name); ?>

                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>
</html>
<?php /**PATH /var/www/html/resources/views/reports/photos_pdf.blade.php ENDPATH**/ ?>