import API from '@/api/api'           // axios‑инстанс с baseURL
import { getAuthHeader } from '@/api/helpers' // функция, возвращающая { Authorization: Bearer … }

class RefService {
    /** менеджеры групп|подгрупп */
    async managers (level = 'group') {
        return API.get('/ref/managers', {
            params  : { level },
            headers : getAuthHeader()
        })
    }

    /** районы */
    async districts () {
        return API.get('/ref/districts', {
            headers : getAuthHeader()
        })
    }
}

export const refService = new RefService()
