import API from '@/api/api.js';

export class RoleService {

    // 1) Получить роли с их разрешениями
    async getRoles() {
        const token = localStorage.getItem('accessToken');
        return API.request({
            method: 'GET',
            url: '/roles?include=permissions',
            headers: {Authorization: `Bearer ${token}`},
        });
    }

    // 2) Получить все разрешения
    async getPermissions() {
        const token = localStorage.getItem('accessToken');
        return API.request({
            method: 'GET',
            url: '/permissions',
            headers: {Authorization: `Bearer ${token}`},
        });
    }

    // 3) Создать разрешение
    createPermission(payload) {
        const token = localStorage.getItem('accessToken');
        return API.request({
            method: 'POST',
            url: '/permissions',
            data: payload,
            headers: {Authorization: `Bearer ${token}`},
        });
    }

    // 4) Удалить разрешение
    deletePermission(id) {
        const token = localStorage.getItem('accessToken');
        return API.request({
            method: 'DELETE',
            url: `/permissions/${id}`,
            headers: {Authorization: `Bearer ${token}`},
        });
    }


    // 5/6) Назначить/снять разрешение у роли
    attachPermission(roleId, permId) {
        const token = localStorage.getItem('accessToken');
        return API.request({
            method: 'POST',
            url: `/roles/${roleId}/permissions/${permId}`,
            headers: {Authorization: `Bearer ${token}`},
        });
    }


    detachPermission(roleId, permId) {
        const token = localStorage.getItem('accessToken');
        return API.request({
            method: 'DELETE',
            url: `/roles/${roleId}/permissions/${permId}`,
            headers: {Authorization: `Bearer ${token}`},
        });
    }

}

export const roleService = new RoleService();