import { createApp } from 'vue';
import 'bootstrap/dist/css/bootstrap.min.css';
import * as bootstrap from 'bootstrap';
import '@/assets/css/style.css';
import router from '@/router/router.js';
import { createPinia } from 'pinia';
import piniaPluginPersistedstate from 'pinia-plugin-persistedstate';
import App from './App.vue';
import Draggable from 'vuedraggable'

const pinia = createPinia();
pinia.use(piniaPluginPersistedstate);

const app = createApp(App);

app.component('Draggable', Draggable).use(router).use(bootstrap).use(pinia).mount('#app');
