import { createRouter, createWebHistory } from 'vue-router';
import { routes } from '@/router/routes.js';
import { useAuthStore } from '@/stores/Auth.js';

const router = createRouter({
    history: createWebHistory(),
    routes,
});

router.beforeEach(async (to, from, next) => {
    const authStore = useAuthStore();
    if (!authStore.user) {
        if (to.meta.auth) {
            // Если маршрут требует авторизации и пользователь не авторизован, перенаправляем на страницу входа
            next({ name: 'login' });
        } else {
            // Если маршрут не требует авторизации, просто продолжаем
            next();
        }
    } else {
        if (to.meta.permission) {
            if (!authStore.hasPermission(to.meta.permission)) {
                next({ name: 'profile' });
            }
        }
    }
    next();
});

export default router;
