import Login from '@/pages/Login.vue';
import Home from '@/pages/Home.vue';
import Profile from '@/pages/Profile.vue';
import AppLayOut from '@/pages/AppLayOut.vue';
import Users from '@/pages/User/Users.vue';
import UsersList from '@/pages/User/UsersList.vue';
import UserProfile from '@/pages/User/UserProfile.vue';
import Logs from '@/pages/Logs.vue';

import Schedule from '@/pages/Schedule/Schedule.vue';
import ScheduleList from '@/pages/Schedule/ScheduleList.vue';
import SchedulePlan from '@/pages/Schedule/SchedulePlan.vue';

import UserRegistration from '@/pages/User/UserRegistration.vue';
import PointPlan from '@/pages/PointPlan/PointPlan.vue';
import PointPlanList from '@/pages/PointPlan/PointPlanList.vue';
import PointPlanCreate from '@/pages/PointPlan/PointPlanCreate.vue';
import PointPlanEdit from '@/pages/PointPlan/PointPlanEdit.vue';
import Points from '@/pages/Point/Points.vue';
import PointCreate from '@/pages/Point/PointCreate.vue';
import PointEdit from '@/pages/Point/PointEdit.vue';
import PointList from '@/pages/Point/PointList.vue';

import Manager from '@/pages/Manager.vue';
import PointsRegistry from '@/pages/PointsRegistry.vue';
import MapPrintLive from '@/pages/MapPrintLive.vue';

import Notifications from '@/pages/Notifications.vue';
import DistrictCard from "@/pages/DistrictCard.vue";
import RoadSchema from "@/pages/RoadSchema.vue";
import GenCalendar from "@/pages/GenCalendar.vue";
import PermissionsPage from '@/pages/PermissionsPage.vue';
import Assignment from "@/pages/Assignment.vue";
import ReportIntens from "@/pages/ReportIntens.vue";
import ActKS2 from '@/pages/ActKS2.vue';
import RequestSet from '@/pages/RequestSet/RequestSet.vue'
import RequestList from '@/pages/RequestSet/RequestList.vue'
import RequestCreate from '@/pages/RequestSet/RequestCreate.vue'
import RequestEdit from '@/pages/RequestSet/RequestEdit.vue'
import PhotoReport from '@/pages/PhotoReport.vue'
import CounterManagement from "@/pages/CounterManagement.vue"
import InfoLetter from '@/pages/InfoLetter.vue'


export const routes = [
    {
        path: '/',
        component: AppLayOut,
        children: [
            {
                path: '',
                component: Home,
                name: 'home',
                meta: {
                    auth: true,
                    title: 'Главная',
                },
            },
            {
                path: '/profile',
                component: Profile,
                name: 'profile',
                meta: {
                    auth: true,
                    title: 'Профиль',
                },
            },
            {
                path: '/counters',
                name: 'counters',
                component: CounterManagement,
                meta: {
                    requiresAuth: true,
                    title: "Учетчики",
                },
            },
            {
                path: '/users',
                component: Users,
                name: 'users',
                meta: {
                    permission: 'view-user',
                    auth: true,
                    title: 'Пользователи',
                },
                children: [
                    {
                        path: 'list',
                        component: UsersList,
                        name: 'users-list',
                        meta: {
                            auth: true,
                            permission: ['view-user', 'delete-user'],
                            title: 'Список пользователей',
                        },
                    },
                    {
                        path: ':id',
                        component: UserProfile,
                        name: 'user-profile',
                        meta: {
                            auth: true,
                            permission: ['view-user', 'update-user'],
                            title: 'Профиль пользователя',
                        },
                    },
                    {
                        path: 'registration',
                        component: UserRegistration,
                        name: 'user-registration',
                        meta: {
                            auth: true,
                            permission: ['view-user', 'create-user'],
                            title: 'Регистрация пользователя',
                        },
                    },
                ],
            },
            {
                path: '/logs',
                component: Logs,
                name: 'logs',
                meta: {
                    auth: true,
                    permission: ['view-logs'],
                    title: 'Логи',
                },
            },
            {
                path: '/point',
                component: Points,
                name: 'point',
                meta: {
                    auth: true,
                    permission: ['view-point-list'],
                    title: 'Точки',
                },
                children: [
                    {
                        path: 'list',
                        component: PointList,
                        name: 'point-list',
                        meta: {
                            auth: true,
                            permission: ['view-point-list', 'create-point', 'update-point'],
                            title: 'Список точек',
                        },
                    },
                    {
                        path: 'create',
                        component: PointCreate,
                        name: 'point-create',
                        meta: {
                            auth: true,
                            permission: ['view-point-list', 'create-point'],
                            title: 'Создание точки',
                        },
                    },
                    {
                        path: 'edit/:id',
                        component: PointEdit,
                        name: 'point-edit',
                        meta: {
                            auth: true,
                            permission: ['view-point-list', 'update-point'],
                            title: 'Редактирование точки',
                        },
                    },
                ],
            },
            {
                path: '/points-registry',
                component: PointsRegistry,
                name: 'points-registry',
                meta: {
                    auth: true,
                    //permission: ['view-point', 'create-point', 'update-point', 'delete-point'],
                    title: 'Реестр пунктов учета интенсивности движения',
                },
            },
            {
                path: '/district-card',
                component: DistrictCard,
                name: 'district-card',
                meta: {
                    auth: true,
                    //permission: ['view-point', 'create-point', 'update-point', 'delete-point'],
                    title: 'Карточка ПУИДД',
                },
            },
            {
                path: '/road-schema',
                component: RoadSchema,
                name: 'road-schema',
                meta: {
                    auth: true,
                    //permission: ['view-point', 'create-point', 'update-point', 'delete-point'],
                    title: 'Схема организации дорожного движения по районам',
                },
            },
            {
                path: '/schedule',
                component: Schedule,
                name: 'schedule',
                meta: {
                    auth: true,
                    // permission: ['view-point', 'create-point', 'update-point', 'delete-point'],
                    title: 'План график',
                },
                children: [
                    {
                        path: 'list',
                        component: ScheduleList,
                        name: 'schedule-list',
                        meta: {
                            auth: true,
                            //permission: ['view-point', 'create-point', 'update-point', 'delete-point'],
                            title: 'Список планов',
                        },
                    },
                    {
                        path: 'schedule-plan/:id',
                        component: SchedulePlan,
                        name: 'schedule-plan',
                        meta: {
                            auth: true,
                            //permission: ['view-point', 'create-point', 'update-point', 'delete-point'],
                            title: 'Создание плана',
                        },
                    },
                ],
            },
            {
                path: '/point-plan',
                component: PointPlan,
                name: 'pointPlan',
                meta: {
                    auth: true,
                    //permission: ['view-point', 'create-point', 'update-point', 'delete-point'],
                    title: 'Планы точек',
                },
                children: [
                    {
                        path: 'list',
                        component: PointPlanList,
                        name: 'pointPlanList',
                        meta: {
                            auth: true,
                            //permission: ['view-point', 'create-point', 'update-point', 'delete-point'],
                            title: 'Список планов',
                        },
                    },
                    {
                        path: ':id',
                        component: PointPlan,
                        name: 'pointPlanInfo',
                        meta: {
                            auth: true,
                            //permission: ['view-point', 'create-point', 'update-point', 'delete-point'],
                            title: 'План на точку',
                        },
                    },
                    {
                        path: 'create',
                        component: PointPlanCreate,
                        name: 'pointPlanCreate',
                        meta: {
                            auth: true,
                            //permission: ['view-point', 'create-point', 'update-point', 'delete-point'],point-plan-info
                            title: 'Создание плана на точку',
                        },
                    },
                    {
                        path: 'edit/:id',
                        component: PointPlanEdit,
                        name: 'point-plan-edit',
                        meta: {
                            auth: true,
                            //permission: ['view-point', 'create-point', 'update-point', 'delete-point'],
                            title: 'Редактирование плана на точку',
                        },
                    },
                ],
            },

            {
                path: '/manager',
                component: Manager,
                name: 'manager',
                meta: {
                    auth: true,
                    permission: ['work-f3'],
                    title: 'АРМ Менеджера подгруппы',
                },
            },
            {
                path: '/gen-calendar',
                component: GenCalendar,
                name: 'gen-calendar',
                meta: {
                    auth: true,
                    // permission: ['operator'],
                    title: 'Генерация работ в календаре',
                },
            },
            {
                path: '/notifications',
                name: 'notifications',
                component: Notifications,
            },
            {
                path: '/roles-permissions',
                component: PermissionsPage,
                name: 'permissions',
                meta: {
                    auth: true,
                    permission: ['manage-permissions'], // или нужное вам право
                    title: 'Управление разрешениями',
                },
            },
            {
                path: '/assignment',
                component: Assignment,
                name: 'assignment',
                meta: {
                    auth: true,
                    permission: ['assign'], // или нужное вам право
                    title: 'Назначение исполнителей',
                },
            },
            {
                path: '/report-intens',
                component: ReportIntens,
                name: 'reportIntens',
                meta: {
                    auth: true,
                    permission: ['view-reports-intens'],
                    title: 'Отчет среднегодовой суточной интенсивности движения по категориям ТС',
                },
            },
            {
                path: '/act-ks2',
                component: ActKS2,
                name: 'actKS2',
                meta: {
                    auth: true,
                    permission: ['create-act-ks2'],   // задайте нужное право
                    title: 'Акт КС-2',
                },
            },
            {
                path: '/photo-report',
                component: PhotoReport,
                name: 'photo-report',
                meta: {
                    auth: true,
                    permission: ['create-photo-report'], // если нужна проверка прав
                    title: 'Фотоотчет',
                },
            },
            {
                path: '/info-letter',
                component: InfoLetter,
                name: 'info-letter',
                meta: {
                    auth: true, // если нужна авторизация
                    permission: ['create-info-letter'],

                    title: 'Информационное письмо',
                },
            },
            {
                path: '/request',
                component: RequestSet,
                name: 'request',
                meta: {
                    auth: true,
                    permission: ['view-requests'],
                    title: 'Заявки'
                },
                children: [
                    {
                        path: 'list',
                        component: RequestList,
                        name: 'request-list',
                        meta: {
                            auth: true,
                            permission: ['view-requests'],
                            title: 'Список заявок'
                        },
                    },
                    {
                        path: 'create',
                        component: RequestCreate,
                        name: 'request-create',
                        meta: {
                            auth: true,
                            permission: ['create-requests'],
                            title: 'Создать заявку'
                        },
                    },
                    {
                        path: 'edit/:id',
                        component: RequestEdit,
                        name: 'request-edit',
                        meta: {
                            auth: true,
                            permission: ['update-requests'],
                            title: 'Редактировать заявку'
                        },
                    },
                ]
            },

        ],
    },
    {
        path: '/login',
        name: 'login',
        component: Login,
        meta: {
            auth: false,
        },
    },
    {
        path: '/map-print-live',
        component: MapPrintLive,
        name: 'map-print-live',
        meta: {
            auth: true,
            title: 'Печать карты',
        },
    },
];
